import 'package:photogram_admin_cp/import/bloc.dart';
import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';
import 'package:photogram_admin_cp/ui/screens/splash_screen.dart';
import 'package:rad/rad.dart';

class AppWrapper extends StatefulWidget {
  const AppWrapper({Key? key}) : super(key: key);

  @override
  State<AppWrapper> createState() => _AppState();
}

class _AppState extends State<AppWrapper> {
  final _auth = AuthBloc();
  final _appContentProvider = AppContentProvider();

  final _apiRepo = ApiRepository();

  @override
  Widget build(BuildContext context) {
    /*
    |--------------------------------------------------------------------------
    | build app
    |--------------------------------------------------------------------------
    */

    return AppProvider(
      auth: _auth,
      apiRepo: _apiRepo,
      appContentProvider: _appContentProvider,
      app: const SplashScreen(),
    );
  }

  @override
  void dispose() {
    _auth.dispose();
    _appContentProvider.dispose();
  }
}
